package com.youqian.api.dto.merchant;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 商户店铺的相册
 * @author youqian mybatis generator 
 * 2020-04-09
 */
@Data
public class MerchantImageDto implements Serializable {
    private static final long serialVersionUID = 15864315568435723L;

    /**
     * 自增ID
     * not null default = null
     */
    private Long id;

    /**
     * 商铺图片ID
     * not null default = null
     */
    private Long merchantImageId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 上传的图片名
     * max length = 20
     * not null default = 
     */
    private String name;

    /**
     * 删除标识
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 显示排序
     * not null default = 0
     */
    private Integer displayOrder;

    /**
     * 1图片 2视频
     * not null default = 1
     */
    private Integer imageType;
}