package com.youqian.api.dto.merchant;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 店铺关注人
 * @author youqian mybatis generator 
 * 2020-03-31
 */
@Data
public class MerchantStoreFollowDto implements Serializable {
    private static final long serialVersionUID = 15856574218947412L;

    /**
     * 自增键
     * not null default = null
     */
    private Long id;

    /**
     * 商户店铺关注ID
     * not null default = 0
     */
    private Long merchantStoreFollowId;

    /**
     * 商户ID,冗余MerchantStore店铺表merchantId字段
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 店铺名称,冗余MerchantStore店铺表name字段
     * max length = 20
     * not null default = 
     */
    private String merchantName;

    /**
     * 关注用户的ID
     * not null default = 0
     */
    private Long followedUserId;

    /**
     * 关注状态，0-取消关注 1-关注
     * not null default = 0
     */
    private Byte status;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}