package com.youqian.api.dto.merchant;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 商户用户关系表
 * @author youqian mybatis generator 
 * 2021-01-07
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MerchantUserRDto implements Serializable {
    private static final long serialVersionUID = 16099972420266752L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long merchantUserRId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 用户id
     * not null default = 0
     */
    private Long userId;

    /**
     * 商户id
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 是否首次进入商户店铺
     * not null default = 0
     */
    private Byte firstIntoStore;
}