package com.youqian.api.dto.merchant;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by hong
 * time 2020/11/26.
 */
@Data
public class OrgCustomerDto implements Serializable {

    private static final long serialVersionUID = -4527500584725596432L;

    /**
     * 组织ID
     * not null default = 0
     */
    private Long orgId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 组织名称
     * max length = 20
     * not null default =
     */
    private String orgName;

    /**
     * 组织名称拼音
     * max length = 100
     * not null default =
     */
    private String orgNamePinyin;

    /**
     * 部门完整命名，例如：A部门-B部门-C部门
     * max length = 255
     * not null default =
     */
    private String orgFullname;

    /**
     * 父类组织ID
     * not null default = 0
     */
    private Long parentOrgId;

    /**
     * 部门下员工数量
     * not null default = 0
     */
    private Integer employeeCount;

    /**
     * 是否删除,0-未删除/其他-已删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}
