package com.youqian.api.dto.order;

import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单的货品关联
 * @author youqian mybatis generator 
 * 2020-04-01
 */
@Data
public class CreateOrderItemDto implements Serializable {
    private static final long serialVersionUID = 15857374892859760L;

    /**
     * 商品ID
     */
    @NotNull(message = "商品ID不能为空")
    @Min(value = 1, message = "商品ID必须大于0")
    private Long goodsId;

    /**
     * 商品名称
     */
    @NotBlank(message = "商品名称不能为空")
    private String goodsName;

    /**
     * 商品款号
     */
    @NotBlank(message = "商品款号不能为空")
    private String shortName;

    /**
     * 商品图片
     */
    @NotBlank(message = "商品图片不能为空")
    private String goodsThumb;

    /**
     * SkuId
     */
    @NotNull(message = "SkuId不能为空")
    @Min(value = 1, message = "SkuId必须大于0")
    private Long skuId;

    /**
     * 商品单价
     */
    @NotNull(message = "商品单价不能为空")
    private BigDecimal price;

    /**
     * 货号商品个数
     */
    private Integer num;

    /**
     * 商品单位
     */
    private String unit;

    /**
     * 商品颜色
     */
    @NotBlank(message = "商品颜色不能为空")
    private String color;

    /**
     * 商品大小
     */
    @NotBlank(message = "商品大小不能为空")
    private String size;
}