package com.youqian.api.dto.page;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 页面与类别关系表
 * @author youqian mybatis generator 
 * 2020-10-15
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class PageCategoryRDto implements Serializable {
    private static final long serialVersionUID = 16027274728945445L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long pageCategoryRId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 类别id
     * not null default = null
     */
    private Long pageCategoryId;

    /**
     * 页面id
     * not null default = null
     */
    private Long pageId;

    /**
     * 是否应用
     * not null default = 1
     */
    private Byte whetherApply;

    /**
     * 主颜色
     * max length = 10
     */
    private String mainColor;

    /**
     * 副颜色
     * max length = 10
     */
    private String subColor;
}