package com.youqian.api.dto.page.custom;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by hong
 * time 2020/10/22.
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class PageCategoryMerchantDto implements Serializable {

    private static final long serialVersionUID = 4938594830950939241L;

    /**
     * 唯一id
     * not null default = null
     */
    private Long pageCategoryId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 类别名
     * max length = 20
     * not null default = null
     */
    private String categoryName;

    /**
     * 是否默认
     * not null default = 0
     */
    private Byte whetherDefault;

    /**
     * 类别版本
     * max length = 10
     * not null default =
     */
    private String categoryVersion;

    /**
     * 类别别名
     * max length = 100
     */
    private String categoryAlias;

    /**
     * 类别描述
     * max length = 255
     */
    private String categoryDesc;

    /**
     * 商户名称列表
     */
    private List<String> merchantNames;
}
