package com.youqian.api.dto.platformuser;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import lombok.Data;

/**
 * 用户表
 * @author youqian mybatis generator 
 * 2020-04-01
 */
@Data
public class PlatformUserDto implements Serializable {
    private static final long serialVersionUID = 15857066715551467L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 员工ID
     */
    private Long employeeId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 用户名称
     * max length = 100
     * not null default = 
     */
    private String userName;

    /**
     * 账号
     * max length = 20
     * not null default = 
     */
    private String account;

    /**
     * 密码
     * max length = 100
     * not null default = 
     */
    private String password;

    /**
     * 手机号码
     * max length = 20
     * not null default = 
     */
    private String mobile;

    /**
     * 头像
     * max length = 500
     * not null default = 
     */
    private String avatarUrl;

    /**
     * 性别,0-未知，1-男，2-女
     * not null default = 0
     */
    private Byte gender;

    /**
     * 出生日期
     */
    private LocalDate birthday;

    /**
     * 实名状态，0-未实名，1-实名中，2-实名完成，3-实名被驳回
     * not null default = 0
     */
    private Byte authStatus;

    /**
     * 是否是买家，0-是，1-不是
     * not null default = 0
     */
    private Byte buyer;

    /**
     * 微信返回-城市编号
     * max length = 5
     * not null default = 
     */
    private String countryCode;

    /**
     * 有签小程序的open_id
     * max length = 64
     * not null default = 
     */
    private String wxMinOpenId;

    /**
     * 有签公众号的open_id
     * max length = 64
     * not null default = 
     */
    private String wxSubOpenId;

    /**
     * 密码是否修改过
     * not null default = 0
     */
    private Byte pwdModified;

    /**
     * 有签的union_id
     * max length = 64
     * not null default = 
     */
    private String wxUnionId;

    /**
     * 直播小程序的open_id
     * max length = 64
     * not null default = 
     */
    private String wxStudioMinOpenId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 确认订单数
     */
    private Integer confirmOrderCount;

    /**
     * 关注店铺数
     */
    private Integer followStoreCount;
    /**
     * 商户Id
     */
    private Long merchantId;
    /**
     * 商户名字
     */
    private String merchantName;
    /**
     * 成员状态
     */
    private Byte status;
    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 账号等级 1主账号  2子账号
     */
    private Integer accountLevel;

    /**
     * 父账号id
     */
    private Long parentUserId;
}