package com.youqian.api.dto.shopgoods;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 商品标签表
 * @author youqian mybatis generator 
 * 2020-03-31
 */
@Data
public class ShopGoodsTagDto implements Serializable {
    private static final long serialVersionUID = 15856513457014714L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long shopGoodsTagId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 标签名
     * max length = 20
     * not null default = null
     */
    private String name;

    /**
     * 显示排序
     * max length = 11
     * not null default = 0
     */
    private Integer displayOrder;

    /**
     * 是否私有  1私有  0公有
     * not null default = 0
     */
    private Byte privated;

    /**
     * 商户id
     */
    private Long merchId;
}