package com.youqian.api.dto.shopgoods.custom;

import com.youqian.api.dto.PageDto;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * 商品和规格标签分页数据汇总
 * Created by hong
 * time 2020/4/7.
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class GoodsSkuTagDto extends PageDto<GoodsAndSkuDto> {
    private static final long serialVersionUID = -1965504980001290751L;

    /**
     * 货品总数
     */
    private Integer goodsCount;

    /**
     * 规格总数
     */
    private Integer skuCount;
    /**
     * 标签名称
     */
    private String tagName;

    /**
     * 标签id
     */
    private Long tagId;
}
