package com.youqian.api.dto.sign;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 用户实名信息表
 * @author youqian mybatis generator 
 * 2020-04-03
 */
@Data
public class UserAuthDto implements Serializable {
    private static final long serialVersionUID = 15859032474001379L;

    /**
     * 用户ID
     * not null default = null
     */
    private Long id;

    /**
     * 用户认证ID
     * not null default = null
     */
    private Long userAuthId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 真实姓名
     * max length = 100
     * not null default = 
     */
    private String realName;

    /**
     * 手机号码/账号
     * max length = 20
     * not null default = 
     */
    private String mobile;

    /**
     * 证件号码
     * max length = 150
     * not null default = 
     */
    private String authIdentity;

    /**
     * 证件类型
     * not null default = 0
     */
    private Byte identityType;

    /**
     * 上上签用户标识
     * max length = 60
     * not null default = 
     */
    private String ssqAccount;

    /**
     * 正面照片的地址
     * max length = 150
     * not null default = 
     */
    private String frontImg;

    /**
     * 反面照片的地址
     * max length = 150
     * not null default = 
     */
    private String backImg;

    /**
     * 证书编号
     * max length = 100
     * not null default = 
     */
    private String certNo;

    /**
     * ssq申请证书taskId
     * max length = 100
     * not null default = 
     */
    private String taskId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}