package com.youqian.api.dto.statistics.order;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 商户订单统计表（总）
 * @author youqian mybatis generator 
 * 2020-09-23
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OrderStatisticsDto implements Serializable {
    private static final long serialVersionUID = 16008622179211367L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 月报ID
     * not null default = 0
     */
    private Long orderStatisticsId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 开单数量
     * not null default = 0
     */
    private Integer openOrderCount;

    /**
     * 开单金额
     * not null default = 0.00
     */
    private BigDecimal openOrderMoney;

    /**
     * 发货数量
     * not null default = 0
     */
    private Integer deliveryCount;

    /**
     * 发货金额
     * not null default = 0.00
     */
    private BigDecimal deliveryMoney;

    /**
     * 回款/收款
     * not null default = 0.00
     */
    private BigDecimal moneyBack;

    /**
     * 待收款金额
     * not null default = 0.00
     */
    private BigDecimal restMoney;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}