package com.youqian.api.dto.survey;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 问卷项目主表
 * @author youqian mybatis generator 
 * 2021-01-13
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SurveyDto implements Serializable {
    private static final long serialVersionUID = 16105255679228855L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long surveyId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 问卷主题
     * max length = 50
     * not null default = 
     */
    private String surveyTitle;

    /**
     * 备注
     * max length = 255
     * not null default = 
     */
    private String surveyRemark;

    /**
     * 0: 非匿名 1:匿名  匿名标志
     * not null default = 0
     */
    private Byte anonymousSurvey;

    /**
     * 完成后允许查看结果0：允许 1：不允许
     * not null default = 0
     */
    private Byte okLook;

    /**
     * 发布后多久内有效 单位(秒)
     * not null default = null
     */
    private Long validPeriod;

    /**
     * 问卷开始时间
     */
    private Date startTime;

    /**
     * 问卷结束时间
     */
    private Date endTime;

    /**
     * 问卷创建人id
     * not null default = 0
     */
    private Long surveyCreator;

    /**
     * 发布时间
     */
    private Date releaseTime;

    /**
     * 有效标志 0：有效 1：无效
     * not null default = 0
     */
    private Byte validFlag;

    /**
     * 问卷类型
     * not null default = 0
     */
    private Integer surveyType;

    /**
     * 直播id
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 商户id
     * not null default = 0
     */
    private Long merchantId;
}