package com.youqian.api.dto.survey;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 问卷问题选项表
 * @author youqian mybatis generator 
 * 2021-01-13
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SurveyOptionsDto implements Serializable {
    private static final long serialVersionUID = 16105255679243666L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long surveyOptionsId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 问卷id
     * not null default = 0
     */
    private Long surveyId;

    /**
     * 问题id
     * not null default = 0
     */
    private Long questionId;

    /**
     * 排序号
     * not null default = 0
     */
    private Integer displayOrder;

    /**
     * 问题类型    冗余问题表
     * not null default = 1
     */
    private Integer itemType;

    /**
     * 选项内容
     * max length = 255
     * not null default = 
     */
    private String itemVal;

    /**
     * 选项类型 1选项 2文本
     * not null default = 1
     */
    private Integer optionsType;
}