package com.youqian.api.dto.wms;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 商品库存进出流水
 * @author youqian mybatis generator 
 * 2020-10-26
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class WmsOrderFlowDto implements Serializable {
    private static final long serialVersionUID = 16037007112447708L;

    /**
     * 自动增长编号
     * not null default = null
     */
    private Long id;

    /**
     * 商品库存流转编号
     * not null default = 0
     */
    private Long wmsOrderFlowId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 删除表示 0-正常 1-删除
     * not null default = null
     */
    private Boolean deleted;

    /**
     * sku编号
     * not null default = 0
     */
    private Long shopGoodsSkuId;

    /**
     * sku名称
     * max length = 100
     * not null default = 
     */
    private String shopGoodsSkuName;

    /**
     * 流转类型 1-入库 2-预定库存 4-预定退货 8-出库  16-盘点
     * not null default = null
     */
    private Boolean flowType;

    /**
     * 流转数量
     * not null default = 0
     */
    private Integer flowQuantity;

    /**
     * 流转单号 入库单号 出库订单号 盘点编号
     * max length = 20
     * not null default = null
     */
    private String flowOrderNo;

    /**
     * 流转单数据库编号
     * not null default = null
     */
    private Long wmsOrderId;

    /**
     * 商品名称
     * max length = 50
     * not null default = 0
     */
    private String goodsName;

    /**
     * 操作人名称
     * max length = 50
     * not null default = 0
     */
    private String employeeName;

    /**
     * 流转明细json描述
     * max length = 1000
     * not null default = null
     */
    private String jssonStr;

    /**
     * 备注
     * max length = 200
     * not null default = 
     */
    private String orderComment;

    /**
     * 0-未消费 1-消费失败   9-消费成功
     * not null default = 0
     */
    private Boolean syncStatus;
}