package com.youqian.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/11/23.
 */
@Getter
public enum AccountLevelEnum {

    MAIN(1, "main", "主账号"),
    SUB(2, "sub", "子账号"),
    ;

    private final Integer code;

    private final String  type;

    private final String  desc;

    AccountLevelEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static AccountLevelEnum getByCode(Integer code) {
        return Stream.of(AccountLevelEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(MAIN);
    }

    public static AccountLevelEnum getByType(String type) {
        return Stream.of(AccountLevelEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(MAIN);
    }
}