package com.youqian.api.enums;

import lombok.Getter;

/**
 * 动作文案
 * @author xiachenhang
 */
@Getter
public enum ActionMsgEnum {
    VISIT_STORE("%s 刚刚访问了您的商户名片"),
    SUBSCRIPTION("%s 订阅了 %s 直播"),
    VISIT_PHOTO("%s 访问 %s 分享的相册"),
    VISIT_STORE_TO_LIVE("%s 在直播间关注了店铺"),
    ENQUIRY_FROM_LIVE("%s 在直播间询价了 %s"),
    COLLECT_FROM_LIVE("%s 在直播间收藏了 %s"),
    VISIT_STORE_FROM_LIVE("%s 在直播间访问了名片"),
    FOLLOW_STORE("%s 关注了店铺"),
    ENQUIRY("%s 询价了 %s"),
    COLLECT("%s 收藏了 %s"),
    ENQUIRY_SHARE_PHOTO("%s 询价了 %s 分享的相册"),
    COLLECT_SHARE_PHOTO("%s 收藏了 %s 分享的相册"),

    ;

    private String message;

    ActionMsgEnum(String message){
        this.message = message;
    }

    public String join(Object... data){
        return String.format(message,data);
    }
}
