package com.youqian.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/10/29
 * @description
 */
@Getter
public enum EnumMerchantApplyStatus {

    /**
     * 申请状态
     */
    WAIT((byte) 0, "未开户"),
    PASS((byte) 1, "已开户"),
    ;

    private final byte code;

    private final String desc;

    EnumMerchantApplyStatus(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static boolean isWait(Byte code) {
        return Objects.equals(WAIT.code, code);
    }

    public static boolean isPass(Byte code) {
        return Objects.equals(PASS.code, code);
    }
}
