package com.youqian.api.enums;

import lombok.Getter;

import java.util.Objects;

@Getter
public enum LogTypeEnum {
    LOG_TYPE_1(1,"新手任务"),
    LOG_TYPE_2(2,"直播运营"),
    LOG_TYPE_3(3,"订单提醒"),
    ;

    private Integer type;
    private String msg;
    LogTypeEnum(Integer type,String msg){
        this.type = type;
        this.msg = msg;
    }

    public static LogTypeEnum get(Integer type){
        if(type == null || type == 0){
            return null;
        }
        for(LogTypeEnum lt:values()){
            if(Objects.equals(type,lt.type)){
                return lt;
            }
        }
        return null;
    }
}
