package com.youqian.api.enums;

import lombok.Getter;

import java.util.Objects;

@Getter
public enum ScoreEnum {
    UN_KNOW("unKnow",0,"未知异常"),
    IS_FIRST("isFirst",100,"是否首次访问"),
    ACCESS_STORE("accessStore",5,"访问店铺"),
    ACCESS_PRE_STORE("accessPreStore",5,"访问预告页"),
    SHOP("shop",5,"访问商品图片"),
    IS_FOLLOW("isFollow",10,"关注店铺"),
    ORDER_BILL("orderBill",5,"提交商品进货单"),
    LIVE_WATCH("liveWatch",20,"观看直播"),
    LIVE_SUB("liveSub",10,"订阅直播"),
    COLLECT("collect",5,"收藏商品"),
    ADD_ORDER_BILL("addOrderBill",5,"加入商品进货单"),
    ;

    private String code;
    private Integer score;
    private String msg;

    ScoreEnum(String code,Integer score,String msg){
        this.code = code;
        this.score = score;
        this.msg = msg;
    }

    public static ScoreEnum get(String code){
        for(ScoreEnum scoreEnum : values()){
            if(Objects.equals(code,scoreEnum.getCode())){
                return scoreEnum;
            }
        }
        return UN_KNOW;
    }
}
