package com.youqian.api.enums.customer;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/8/11.
 */
@Getter
public enum CustomerLabelTypeEnum {

    REGULAR((byte)1,"regular","固定标签"),
    CUSTOMIZE((byte)2,"customize","商户添加的标签");

    private final Byte code;

    private final String type;

    private final String desc;

    CustomerLabelTypeEnum(Byte code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static CustomerLabelTypeEnum getByCode(Byte code) {
        return Stream.of(CustomerLabelTypeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(CUSTOMIZE);
    }

    public static CustomerLabelTypeEnum getByType(String type) {
        return Stream.of(CustomerLabelTypeEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(CUSTOMIZE);
    }
}

