package com.youqian.api.enums.goods;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/10/27.
 */
@Getter
public enum GoodsTypeEnum {

    UNITARY(1,"UNITARY","一元商品"),
    DUALITY(2,"DUALITY","二元商品");

    private final Integer code;

    private final String type;

    private final String desc;

    GoodsTypeEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static GoodsTypeEnum getByCode(Integer code) {
        return Stream.of(GoodsTypeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(DUALITY);
    }

    public static GoodsTypeEnum getByType(String type) {
        return Stream.of(GoodsTypeEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(DUALITY);
    }
}

