package com.youqian.api.enums.innerlog;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/9/27.
 */
@Getter
public enum InnerLogTypeEnum {

    EXPOSURE(1,"exposure", "曝光日志"),;

    private final Integer code;

    private final String type;

    private final String desc;

    InnerLogTypeEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static InnerLogTypeEnum getByCode(Integer code) {
        return Stream.of(InnerLogTypeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(EXPOSURE);
    }

    public static InnerLogTypeEnum getByType(String type) {
        return Stream.of(InnerLogTypeEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(EXPOSURE);
    }
}

