package com.youqian.api.enums.shoptag;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/4/7.
 */
@Getter
public enum TagPrivateEnum {
    PRIVATE((byte)1,"private","私有"),
    PUBLIC((byte)0,"public","公有")
    ;

    private final Byte code;

    private final String type;

    private final String desc;

    TagPrivateEnum(Byte code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static TagPrivateEnum getByCode(Byte code) {
        return Stream.of(TagPrivateEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(PRIVATE);
    }

    public static TagPrivateEnum getByType(String type) {
        return Stream.of(TagPrivateEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(PUBLIC);
    }
}

