package com.youqian.api.params.goods;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.youqian.api.params.goods.AddSkuSpecParam;
import com.youqian.api.params.goods.InsertPicBatchParam;
import com.youqian.api.params.goods.spec.AddSkuSpecParamV1;
import com.youqian.api.params.shoptag.GoodsTagRelationParam;
import com.youqian.api.util.BigDecimalDeserializer;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * Created by hong
 * time 2020/10/22.
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class AddGoodsParamV2 implements Serializable {

    private static final long            serialVersionUID = -1352958573004338274L;

    /**
     * 商品名
     */
    @NotBlank(message = "商品名不能为空")
    @Size( max= 20,min = 1,message = "商品名应为1-20位")
    private String                       goodsName;

    /**
     * 货号
     */
    @NotBlank(message = "商品编号不能为空")
    @Size( max= 20,min = 1,message = "商品编号应为1-20位")
    private String                       shortName;

    /**
     * 是否推荐  1是
     * @see com.youqian.api.enums.TrueOrFalseEnum
     */
    private Integer                      recommend;

    /**
     * 单位
     */
    private String unit;

    /**
     * 单价
     */
    @JsonDeserialize(using = BigDecimalDeserializer.class)
    private BigDecimal marketPrice= BigDecimal.ZERO;

    /**
     * 是否上新 1是
     */
    private Byte newPublish;

    /**
     * 是否热卖  1是
     */
    private Byte hot;

    /**
     * 是否促销   1是
     */
    private Byte discount;

    /**
     * 标签数组
     */
    private List<GoodsTagRelationParam> tags;

    /**
     * 商品图片oss数组
     */
    private List<InsertPicBatchParam> goodsPics;

    /**
     * 规格操作参数数组
     */
    private List<AddSkuParam> addSkuSpecParam;

    /**
     * 商品id集合(商品删除用)
     */
    private List<Long>                   goodsIds;

    /**
     * 商户ID
     */
    private Long merchantId;

    /**
     * 用户ID
     */
    private Long userId;
}
