package com.youqian.api.params.goods;

import com.youqian.uid.annotation.AutoId;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 批量插入图片参数集合
 * Created by hong
 * time 2020/4/8.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class InsertPicBatchParam implements Serializable {

    private static final long serialVersionUID = 5146124709663876991L;

    /**
     * 商品图片id
     */
    @AutoId
    private Long         shopGoodsPictureId;

    /**
     * 商品图片
     */
    private String       oss;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte         deleted;

    /**
     * 1图片 2视频
     * not null default = null
     */
    private Integer type = 1;
}
