package com.youqian.api.params.merchant;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
public class FollowMerchantParam {
    /**
     * 商户ID
     */
    @ApiModelProperty(value = "商户ID", required = true)
    @NotNull(message = "商户ID不能为空")
    private Long merchantId;

    /**
     * 关注状态
     * @ses com.youqian.api.enums.FollowStatusEnum 0-取消关注 1-关注
     */
    public Integer code;

    public Long followedUserId;

    /**
     * 来源 0-直播间 1-店铺
     */
    @NotNull(message = "来源不能为空")
    private Integer type;

    /**
     * 房间号
     */
    private Long liveRoomId;

}
