package com.youqian.api.params.merchant;

import com.youqian.api.dto.merchant.MerchantImageDto;
import com.youqian.api.dto.merchant.customize.ImageNameAndTypeDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * @author xiachenhang
 */
@Data
public class MerchantStoreParam {

    @ApiModelProperty("公司名")
    private String name;

    @Size(max = 50, min = 1, message = "公司描述长度要在1-50之间")
    @ApiModelProperty("公司描述")
    private String description;

    @NotBlank(message = "请上传公司logo")
    @ApiModelProperty("公司logo")
    private String logoOssId;

    @NotBlank(message = "请输入公司电话")
    @ApiModelProperty("公司电话")
    private String mobilePhone;

    @NotBlank(message = "请输入公司地址")
    @Size(max = 40, min = 1, message = "详细地址长度要在1-40之间")
    @ApiModelProperty("公司地址")
    private String address;

    @ApiModelProperty("地址经度")
    private String longtitude;

    @ApiModelProperty("地址纬度")
    private String latitude;

    @ApiModelProperty("省编码")
    private String provinceCode;

    @ApiModelProperty("市编码")
    private String cityCode;

    @ApiModelProperty("区编码")
    private String areaCode;

    @ApiModelProperty("商户ID")
    private Long merchantId;

    @ApiModelProperty("地址-省市区")
    private String simpleAddress;

    @ApiModelProperty("标签ID")
    private List<Long> tagList;

    /**
     * 微信二维码
     */
    private String linkmanQrcode;

    /**
     * 职务
     */
    private String linkmanJob;

    /**
     * 店铺公告
     */
    private String merchantNotice;

    /**
     * 老板名字
     */
    private String bossName;

    /**
     * 相册oss
     */
    private List<ImageNameAndTypeDto> imgList;
}
