package com.youqian.api.params.statistics;

import com.youqian.api.params.PageParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

/**
 * Created by hong
 * time 2020/11/20.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class EmployeeCustomerStatisticsParam extends PageParam implements Serializable {

    private static final long serialVersionUID = 4313446185404103881L;

    /**
     * 年份
     */
    private Integer years=getYear(new Date());

    /**
     * 月份
     */
    private Integer month=0;

    /**
     * 商户id
     */
    private Long merchantId=0L;

    private int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(Calendar.YEAR);
    }

    /**
     * 员工id(查询单个员工新客户来源发布用)
     */
    private Long employeeId;
}
