package com.youqian.api.params.statistics;


import com.youqian.api.params.PageParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * Created by hong
 * time 2020/11/17.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PlatformMerchantStatisticsParam extends PageParam implements Serializable {

    private static final long serialVersionUID = -2743162439215785260L;

    /**
     * 年份
     */
    private Integer years=getYear(new Date());

    /**
     * 月份
     */
    private Integer month=0;

    /**
     * 商户id
     */
    private List<Long> merchantIds;

    /**
     * 排序字段
     */
    private String sort;

    /**
     * 排序序列
     */
    private String sortSequence;

    private int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(Calendar.YEAR);
    }
}
