package com.youqian.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.youqian.api.dto.PageDto;
import com.youqian.api.dto.page.PageCategoryDto;
import com.youqian.api.dto.page.custom.PageCategoryMerchantDto;
import com.youqian.api.dto.page.custom.PageCategoryRelationDto;
import com.youqian.api.dto.page.custom.PageComponentRelationDto;
import com.youqian.api.dto.page.custom.ComponentScopeDto;
import com.youqian.api.params.page.AddCategoryParam;
import com.youqian.api.params.page.AddComponentParam;
import com.youqian.api.params.page.AddPageParam;
import com.youqian.api.params.page.ApplyPageParam;
import com.youqian.api.params.page.CategoryListParam;
import com.youqian.api.params.page.CategoryPageComponentListParam;
import com.youqian.api.params.page.CategoryPageListParam;
import com.youqian.api.params.page.ComponentListParam;
import com.youqian.api.params.page.ModifyCategoryParam;
import com.youqian.api.params.page.ModifyColorParam;
import com.youqian.api.params.page.ModifyComponentParam;
import com.youqian.api.params.page.ModifyPageParam;
import com.youqian.api.params.page.PageListParam;
import com.youqian.api.params.page.SaveComponentParam;

import java.util.List;

/**
 * Created by hong
 * time 2020/10/13.
 */
@AdvancedFeignClient
public interface RemotePageService {

    /**
     * 添加页面
     */
    Boolean addPage(AddPageParam addPageParam);

    /**
     * 修改页面
     */
    Boolean modifyPage(ModifyPageParam modifyTemplateParam);

    /**
     * 添加组件
     */
    Boolean addComponent(AddComponentParam templateListParam);

    /**
     * 修改组件
     */
    Boolean modifyComponent(ModifyComponentParam templateListParam);

    /**
     * 页面列表
     */
    PageDto<com.youqian.api.dto.page.PageDto> getPageList(PageListParam pageListParam);

    /**
     * 组件列表
     */
    PageDto<ComponentScopeDto> getComponentList(ComponentListParam componentListParam);

    /**
     * 获取全部页面
     */
    List<com.youqian.api.dto.page.PageDto> getAllPageList();

    /**
     * 类别模板列表
     */
    PageDto<PageCategoryMerchantDto> getCategoryList(CategoryListParam categoryListParam);

    /**
     * 添加类别模板
     */
    Boolean addCategory(AddCategoryParam addCategoryParam);

    /**
     * 修改类别模板
     */
    Boolean modifyCategory(ModifyCategoryParam modifyCategoryParam);

    /**
     * 模板内页面列表
     */
    List<PageCategoryRelationDto> getCategoryPageList(CategoryPageListParam categoryPageListParam);

    /**
     * 模板内页面内组件列表
     */
    List<PageComponentRelationDto> getCategoryPageComponentList(CategoryPageComponentListParam categoryPageComponentListParam);

    /**
     * 保存组件
     */
    Boolean saveComponent(SaveComponentParam saveComponentParam);

    /**
     * 应用页面
     */
    Boolean applyPage(ApplyPageParam applyPageParam);

    /**
     * 修改颜色
     */
    Boolean modifyColor(ModifyColorParam modifyColorParam);

    /**
     * 获取所有类别模板列表
     */
    List<PageCategoryDto> getAllCategoryList();
}
