package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author xiachenhang
 */
@Data
public class GoodsPriceResult {

    @NotNull(message = "商品ID不能为空")
    @Min(value = 1, message = "商品ID必须大于0")
    @ApiModelProperty("商品ID")
    private Long goodsId;

    @NotBlank(message = "价格不能为空")
    @ApiModelProperty("商品价格")
    private String price;


}
