package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Data
public class SaveBillRequest implements Serializable {

    @Min(1)
    @NotNull(message = "商户ID不能为空")
    @ApiModelProperty("商户ID")
    private Long merchantId;

    @ApiModelProperty("用户Id")
    private Long userId;

    @ApiModelProperty("报价单ID-不传则是保存，传则是更新")
    private Long orderReportBillId;

    @ApiModelProperty("商品ID")
    private Long goodsId;

    @ApiModelProperty("直播间ID")
    private Long liveRoomId;

    @ApiModelProperty("规格组")
    private List<SaveGoodsRequest> goodsList;

    @ApiModelProperty("token，前端忽略")
    private Long token;

    @ApiModelProperty("ip，前端忽略")
    private String ip;


}
