package com.youqian.api.response;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author tengtuox
 * @date 2020/9/23
 * @description
 */
@Data
public class EmpOrderCommonStatistics implements Serializable {

    public static final EmpOrderCommonStatistics DEFAULT = new EmpOrderCommonStatistics();

    /**
     * 员工ID
     */
    private Long employeeId;

    /**
     * 开单数量
     */
    private Integer openOrderCount = 0;

    /**
     * 开单金额
     */
    private BigDecimal openOrderMoney = BigDecimal.ZERO;

    /**
     * 发货数量
     */
    private Integer deliveryCount = 0;

    /**
     * 发货金额
     */
    private BigDecimal deliveryMoney = BigDecimal.ZERO;

    /**
     * 回款/收款
     */
    private BigDecimal moneyBack = BigDecimal.ZERO;
}
