package com.youqian.api.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 商品信息
 * @author xiachenhang
 */
@Data
public class OrderBillGoodsResult {

    @ApiModelProperty("商品名称")
    private String goodsName;

    @ApiModelProperty("商品款号")
    private String goodsShortName;

    @ApiModelProperty("商品图片")
    private String goodsUrl;

    @ApiModelProperty("商品单价")
    private BigDecimal goodsPriceCount;

    @ApiModelProperty("商品单价")
    private String goodsPrice;

    @ApiModelProperty("商品总价")
    private String goodsTotalPrice;

    @ApiModelProperty("商品总价")
    private BigDecimal goodsTotalPriceCount;

    @ApiModelProperty("商品ID")
    private Long goodsId;

    @ApiModelProperty("商品总件数")
    private Integer goodsNum;

    @ApiModelProperty("商品总款数")
    private Integer goodsCount;

    @ApiModelProperty("图片规格")
    private List<GoodsSpecBillResult> goodsSpecList;

    @ApiModelProperty("时间")
    private Date createTime;

}
