package com.youqian.api.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author tengtuox
 * @date 2020/9/22
 * @description
 */
@Data
public class OrderStatisticsRangeResult implements Serializable {

    public static final List<ChartsSeries> DEFAULT_SERIES = new ArrayList<>();
    static {
        ChartsSeries openOrderCountSeries = new ChartsSeries();
        openOrderCountSeries.setName("开单量");
        openOrderCountSeries.setYAxisIndex(0);
        DEFAULT_SERIES.add(openOrderCountSeries);

        // 开单金额
        ChartsSeries openOrderMoneySeries = new ChartsSeries();
        openOrderMoneySeries.setName("开单金额");
        openOrderMoneySeries.setYAxisIndex(1);
        DEFAULT_SERIES.add(openOrderCountSeries);

        // 发货单量
        ChartsSeries deliveryCountSeries = new ChartsSeries();
        deliveryCountSeries.setName("发货单量");
        deliveryCountSeries.setYAxisIndex(0);
        DEFAULT_SERIES.add(deliveryCountSeries);

        // 发货金额
        ChartsSeries deliveryMoneySeries = new ChartsSeries();
        deliveryMoneySeries.setName("发货金额");
        deliveryMoneySeries.setYAxisIndex(1);
        DEFAULT_SERIES.add(deliveryCountSeries);

        // 实收金额
        ChartsSeries moneyBackSeries = new ChartsSeries();
        moneyBackSeries.setName("实收金额");
        moneyBackSeries.setYAxisIndex(1);
        DEFAULT_SERIES.add(moneyBackSeries);
    }

    @ApiModelProperty("x轴值")
    private ChartsXAxis xAxis;

//    private List<ChartsYAxis> yAxis;

    @ApiModelProperty("折线数据")
    private List<ChartsSeries> series = DEFAULT_SERIES;

}
