/*
 * Decompiled with CFR 0.152.
 */
package com.youqian.api.echarts.data;

import com.youqian.api.echarts.code.Symbol;
import com.youqian.api.echarts.style.ItemStyle;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class TreeData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Double value;
    private Object symbol;
    private Object symbolSize;
    private List<TreeData> children;
    private ItemStyle itemStyle;

    public TreeData() {
    }

    public TreeData(String name, Double value) {
        this.name = name;
        this.value = value;
    }

    public TreeData(String name, Integer value) {
        this.name = name;
        this.value = value.doubleValue();
    }

    public TreeData name(String name) {
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    public TreeData value(Double value) {
        this.value = value;
        return this;
    }

    public TreeData symbol(Object symbol) {
        this.symbol = symbol;
        return this;
    }

    public TreeData symbol(Symbol symbol) {
        this.symbol = symbol;
        return this;
    }

    public Object symbolSize() {
        return this.symbolSize;
    }

    public TreeData symbolSize(Object symbolSize) {
        this.symbolSize = symbolSize;
        return this;
    }

    public TreeData children(TreeData ... treeDatas) {
        if (treeDatas == null || treeDatas.length == 0) {
            return this;
        }
        this.children().addAll(Arrays.asList(treeDatas));
        return this;
    }

    public List<TreeData> children() {
        if (this.children == null) {
            this.children = new LinkedList<TreeData>();
        }
        return this.children;
    }

    public TreeData itemStyle(ItemStyle itemStyle) {
        this.itemStyle = itemStyle;
        return this;
    }

    public ItemStyle itemStyle() {
        if (this.itemStyle == null) {
            this.itemStyle = new ItemStyle();
        }
        return this.itemStyle;
    }

    public String getName() {
        return this.name;
    }

    public Double getValue() {
        return this.value;
    }

    public Object getSymbol() {
        return this.symbol;
    }

    public Object getSymbolSize() {
        return this.symbolSize;
    }

    public List<TreeData> getChildren() {
        return this.children;
    }

    public ItemStyle getItemStyle() {
        return this.itemStyle;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public void setSymbol(Object symbol) {
        this.symbol = symbol;
    }

    public void setSymbolSize(Object symbolSize) {
        this.symbolSize = symbolSize;
    }

    public void setChildren(List<TreeData> children) {
        this.children = children;
    }

    public void setItemStyle(ItemStyle itemStyle) {
        this.itemStyle = itemStyle;
    }
}

