/*
 * Decompiled with CFR 0.152.
 */
package com.youqian.api.echarts.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.youqian.api.echarts.code.SeriesType;
import com.youqian.api.echarts.series.Bar;
import com.youqian.api.echarts.series.Boxplot;
import com.youqian.api.echarts.series.Candlestick;
import com.youqian.api.echarts.series.EffectScatter;
import com.youqian.api.echarts.series.Funnel;
import com.youqian.api.echarts.series.Gauge;
import com.youqian.api.echarts.series.Graph;
import com.youqian.api.echarts.series.Line;
import com.youqian.api.echarts.series.Lines;
import com.youqian.api.echarts.series.Map;
import com.youqian.api.echarts.series.Parallel;
import com.youqian.api.echarts.series.Pie;
import com.youqian.api.echarts.series.Sankey;
import com.youqian.api.echarts.series.Scatter;
import com.youqian.api.echarts.series.Series;
import java.lang.reflect.Type;

public class SeriesDeserializer
implements JsonDeserializer<Series> {
    public Series deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String _type = jsonObject.get("type").getAsString();
        SeriesType type = SeriesType.valueOf(_type);
        Series series = null;
        switch (type) {
            case line: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Line.class);
                break;
            }
            case bar: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Bar.class);
                break;
            }
            case scatter: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Scatter.class);
                break;
            }
            case funnel: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Funnel.class);
                break;
            }
            case pie: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Pie.class);
                break;
            }
            case gauge: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Gauge.class);
                break;
            }
            case map: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Map.class);
                break;
            }
            case lines: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Lines.class);
                break;
            }
            case effectScatter: {
                series = (Series)context.deserialize((JsonElement)jsonObject, EffectScatter.class);
                break;
            }
            case candlestick: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Candlestick.class);
                break;
            }
            case graph: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Graph.class);
                break;
            }
            case boxplot: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Boxplot.class);
                break;
            }
            case parallel: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Parallel.class);
                break;
            }
            case sankey: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Sankey.class);
            }
        }
        return series;
    }
}

