/*
 * Decompiled with CFR 0.152.
 */
package com.youqian.api.enums;

import java.util.stream.Stream;

public enum AccountLevelEnum {
    MAIN(1, "main", "\u4e3b\u8d26\u53f7"),
    SUB(2, "sub", "\u5b50\u8d26\u53f7");

    private final Integer code;
    private final String type;
    private final String desc;

    private AccountLevelEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static AccountLevelEnum getByCode(Integer code) {
        return Stream.of(AccountLevelEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(MAIN);
    }

    public static AccountLevelEnum getByType(String type) {
        return Stream.of(AccountLevelEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(MAIN);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }
}

