package com.youqian.api.dto.accesslog;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 商户停留表线索
 * @author youqian mybatis generator 
 * 2020-09-23
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AccessStayLogDto implements Serializable {
    private static final long serialVersionUID = 16008408449054587L;

    /**
     * 自增键ID
     * not null default = null
     */
    private Long id;

    /**
     * 商户本次停留ID
     * not null default = 0
     */
    private Long accessStayId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 进入时间
     */
    private Date stayTime;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}