package com.youqian.api.dto.customer;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 客户行为状态表
 * @author youqian mybatis generator 
 * 2020-12-29
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CustomerEnquiryDto implements Serializable {
    private static final long serialVersionUID = 16092098436402219L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 客户询价ID
     * not null default = 0
     */
    private Long customerEnquiryId;

    /**
     * 客户操作ID
     * not null default = 0
     */
    private Long customerIntentExtId;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 客户ID
     * not null default = 0
     */
    private Long customerId;

    /**
     * 直播商品ID
     * not null default = 0
     */
    private Long liveGoodsId;

    /**
     * 商品ID
     * not null default = 0
     */
    private Long goodsId;

    /**
     * 操作类型 1-询价 2-截图
     * not null default = 0
     */
    private Byte actionType;

    /**
     * 操作来源 1-直播 2-回放
     * not null default = 0
     */
    private Byte actionSource;

    /**
     * 截图:播放的时间-毫秒
     * not null default = 0
     */
    private Long playTime;

    /**
     * 删除状态
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}