package com.youqian.api.dto.customer;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 客户行为状态表
 * @author youqian mybatis generator 
 * 2020-12-29
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CustomerIntentExtDto implements Serializable {
    private static final long serialVersionUID = 16092088805627334L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 客户操作ID
     * not null default = 0
     */
    private Long customerIntentExtId;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 客户ID
     * not null default = 0
     */
    private Long customerId;

    /**
     * 操作人ID
     * not null default = 0
     */
    private Long operatorUserId;

    /**
     * 操作员工ID
     * not null default = 0
     */
    private Long operatorEmployeeId;

    /**
     * 意向状态,0-待跟进 1-已跟进 2-已下单 3-已忽略
     * not null default = 0
     */
    private Byte intentStatus;

    /**
     * 最新操作时间
     */
    private Date recentVisitorTime;

    /**
     * 删除状态
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}