package com.youqian.api.dto.customer;

import java.io.Serializable;
import java.util.Date;

import com.youqian.uid.annotation.AutoId;
import lombok.Data;

/**
 * 客户数据统计表
 * @author youqian mybatis generator 
 * 2020-08-13
 */
@Data
public class CustomerStatisticalDto implements Serializable {
    private static final long serialVersionUID = 15973202070965466L;

    /**
     * 自增键ID
     * not null default = null
     */
    private Long id;

    /**
     * 客户数据统计表ID
     * not null default = 0
     */
    @AutoId
    private Long customerStatisticalId;

    /**
     * 查看客户店铺名片
     * not null default = 0
     */
    private Integer watchStore;

    /**
     * 客户ID
     * not null default = 0
     */
    private Long customerId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 关注名片天数
     * not null default = 0
     */
    private Integer follow;

    /**
     * 累计访问
     * not null default = 0
     */
    private Integer watchCount;

    /**
     * 观看直播
     * not null default = 0
     */
    private Integer watchLive;

    /**
     * 浏览直播预告
     * not null default = 0
     */
    private Integer watchPreLive;

    /**
     * 观看直播时长（分钟）
     * not null default = 0
     */
    private Integer liveTime;

    /**
     * 发送评论
     * not null default = 0
     */
    private Integer liveComment;

    /**
     * 参与弹幕抽奖
     * not null default = 0
     */
    private Integer raffle;

    /**
     * 店铺浏览商品
     * not null default = 0
     */
    private Integer watchGoodsStore;

    /**
     * 直播间查看图片
     * not null default = 0
     */
    private Integer watchGoodsLive;

    /**
     * 订阅直播
     */
    private Integer sub;

    /**
     * 0-30天，1-全部
     * not null default = 0
     */
    private Byte yqType;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}