package com.youqian.api.dto.customer.custom;

import com.youqian.api.dto.PageDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 客户画像客户来源
 * 泛型（员工邀请的客户数据）
 * Created by hong
 * time 2020/8/18.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CustomerSourceDto extends PageDto<EmployeeInviteCustomerCountDto> {

    private static final long serialVersionUID = -7402558191897176604L;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * x轴值
     */
    private List<Integer> xAxisValue;

    public static CustomerSourceDto createDto(List<EmployeeInviteCustomerCountDto> list, int pageNo, int pageSize, int totalSize) {
        CustomerSourceDto pageDto = new CustomerSourceDto();
        pageDto.setList(list);
        pageDto.setPageNo(pageNo);
        pageDto.setPageSize(pageSize);
        pageDto.setTotalSize(totalSize);
        pageDto.setHasNext(list.size() == pageSize&&pageNo*pageSize!=totalSize);
        int totalPage = (totalSize % pageSize == 0) ? totalSize / pageSize : (totalSize / pageSize + 1);
        pageDto.setTotalPages(totalPage);
        return pageDto;
    }
}
