package com.youqian.api.dto.employee;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 员工表
 * @author youqian mybatis generator 
 * 2020-03-31
 */
@Data
public class EmployeeDto implements Serializable {
    private static final long serialVersionUID = 15856567551468562L;

    /**
     * 自增键
     * not null default = null
     */
    private Long id;

    /**
     * 员工ID
     * not null default = 0
     */
    private Long employeeId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 商户名称
     * max length = 100
     * not null default = 
     */
    private String merchantName;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 组织ID
     * not null default = 0
     */
    private Long orgId;

    /**
     * 组织名称
     * max length = 20
     * not null default = 
     */
    private String orgName;

    /**
     * 组织全名
     */
    private String orgFullname;

    /**
     * 是否是商户超级管理员（超级管理员账号不是手机号，不能登陆小程序），0-不是/1-是
     * not null default = 0
     */
    private Byte superAdmin;

    /**
     * 角色ID
     * not null default = 0
     */
    private Long roleId;

    /**
     * 账号，冗余PlatformUser表account字段
     * max length = 100
     * not null default = 
     */
    private String account;

    /**
     * 手机号码，冗余PlatformUser表mobile字段
     * max length = 20
     * not null default = 
     */
    private String mobile;

    /**
     * 员工名称，冗余platformUser表的userName字段
     * max length = 100
     * not null default = 
     */
    private String employeeName;

    /**
     * 员工状态，0-正常/1-禁用
     * not null default = 0
     */
    private Byte status;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 员工二维码-有签销售
     * max length = 100
     * not null default = 
     */
    private String qrcode;

    /**
     * 店铺二维码
     * max length = 100
     * not null default = 
     */
    private String storeQrcode;

    /**
     * 获取手机总数
     * max length = 11
     * not null default =
     */
    private Integer totalGetPhone;

    /**
     * 身份 0-员工 1-管理员
     */
    private Byte identity;

    /**
     * 0-非部门主管
     * 1-部门主管
     */
    private Byte orgAdmin;
}