package com.youqian.api.dto.order;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import lombok.Data;

/**
 * 订单信息统计表（日）
 * @author youqian mybatis generator 
 * 2020-04-01
 */
@Data
public class OrderReportDayDto implements Serializable {
    private static final long serialVersionUID = 15857058314026068L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 日报ID
     * not null default = 0
     */
    private Long reportDayId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 开单数量
     * not null default = 0
     */
    private Integer openOrderCount;

    /**
     * 确认订单量
     * not null default = 0
     */
    private Integer confirmedOrderCount;

    /**
     * 营业额
     * not null default = 0.00
     */
    private BigDecimal turnover;

    /**
     * 回款/收款
     * not null default = 0.00
     */
    private BigDecimal moneyBack;

    /**
     * 统计日期
     * not null default = null
     */
    private LocalDate reportDate;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 报单数量
     */
    private Integer reportCount;
}