package com.youqian.api.dto.order;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 用户提货表
 * @author youqian mybatis generator 
 * 2020-04-08
 */
@Data
public class UserDeliveryDto implements Serializable {
    private static final long serialVersionUID = 15863335615577708L;

    /**
     * 提货信息ID
     * not null default = 0
     */
    private Long userDeliveryId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 提货人名称
     * max length = 20
     * not null default = 
     */
    private String name;

    /**
     * 提货人手机号码
     * max length = 20
     * not null default = 
     */
    private String mobile;

    /**
     * 是否删除，0-未删除，其他-已删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}