package com.youqian.api.dto.redpack.custom;

import com.youqian.uid.annotation.AutoId;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 红包参与账单dto
 * Created by hong
 * time 2020/7/17.
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class RedpackParticipationBillDto {


    /**
     * 红包参与列表
     */
    List<ParticipationBillDto> participationBillList;

    /**
     * 红包退回金额
     * not null default = 0.0000
     */
    private BigDecimal returnAmount = BigDecimal.ZERO;

    private Long redpackId;

    /**
     * 发红包商户
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 发红包员工
     * not null default = 0
     */
    private Long employeeId;

    /**
     * 红包金额
     * not null default = 0.0000
     */
    private BigDecimal amount;

    /**
     * 单个红包金额
     * not null default = 0.0000
     */
    private BigDecimal unitamount;

    /**
     * 红包个数
     * not null default = 0
     */
    private Integer total;

    /**
     * 红包剩余个数
     * not null default = 0
     */
    private Integer remain;

    /**
     * 发红包时间
     */
    private Date sendDate;

    /**
     * 是否随机金额
     * not null default = null
     */
    private Byte randomAmount;

    /**
     * 是否关注后参与
     * not null default = 0
     */
    private Byte followAfterRaffle;

    /**
     * 红包名
     * max length = 30
     * not null default = null
     */
    private String redpackName;

    /**
     * 直播id
     * not null default = null
     */
    private Long liveId;

    /**
     * 几分钟后发红包
     */
    private Integer sendAfterMinutes;


    /**
     * 红包状态 0正在发放 1待发放  2发放完成  3取消发放
     * not null default = 0
     */
    private Byte redpackStatus;

    /**
     * 红包结束发放时间
     */
    private Date endDate;


    /**
     * 倒计时
     */
    private Long countdown;

    /**
     * 当前时间
     */
    private Date currentTime;

    /**
     * 已发红包数
     */
    private Integer sendRedpackcount;

    /**
     * 红包剩余金额
     */
    private BigDecimal surplusAmount;

    /**
     * 几秒被抢光
     */
    private Long robbedInSeconds;

    /**
     * 已发金额
     */
    private BigDecimal amountSent;

    /**
     * 开始发放时间
     */
    private Date startDate;
}
