package com.youqian.api.dto.redpack.custom;

import com.youqian.api.dto.redpack.RedpackParticipationDto;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 红包发放详情
 * Created by hong
 * time 2020/7/21.
 */
@Data
public class RedpackUserInfoDto {

    /**
     * 抽中人金额列表
     */
    List<RedpackParticipationDto> redpackParticipationDtos;

    /**
     * 红包状态 0正在发放 1待发放  2发放完成  3取消发放
     * not null default = 0
     */
    private Byte redpackStatus;

    /**
     * 红包结束发放时间
     */
    private Date endDate;

    /**
     * 红包金额
     * not null default = 0.0000
     */
    private BigDecimal amount;

    /**
     * 发红包时间
     */
    private Date sendDate;

    /**
     * 几秒抢完
     */
    private Long robbedInSeconds;

    /**
     * 红包个数
     * not null default = 0
     */
    private Integer total;
}
