package com.youqian.api.dto.reportmain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 用户报价表
 * @author youqian mybatis generator 
 * 2020-06-10
 */
@Data
public class OrderReportMainDto implements Serializable {
    private static final long serialVersionUID = 1591758983160652L;

    /**
     * 自增键ID
     * not null default = null
     */
    private Long id;

    /**
     * 用户的报单ID
     * not null default = 0
     */
    private Long orderReportMainId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 操作人ID
     * not null default = 0
     */
    private Long operatorId;

    /**
     * 总数量
     * not null default = 0
     */
    private Integer goodsNum;

    /**
     * 总价
     * not null default = 0.00
     */
    private BigDecimal totalPrice;

    /**
     * 优惠总价
     * not null default = 0.00
     */
    private BigDecimal reduceTotalPrice;

    /**
     * 报价单状态:0-买家创建 1-卖家报价 2-买家确认
     * not null default = 0
     */
    private Byte status;

    /**
     * 删除标识
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}